/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jpcsp.Allegrex.Common;
import jpcsp.Allegrex.Decoder;
import jpcsp.Allegrex.Instructions;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Allegrex.compiler.RuntimeContextLLE;
import jpcsp.Emulator;
import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEFunctions;
import jpcsp.HLE.HLELogging;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEModuleFunction;
import jpcsp.HLE.HLEModuleManager;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.PspString;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.Managers;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.SceLoadCoreBootInfo;
import jpcsp.HLE.kernel.types.SceLoadCoreBootModuleInfo;
import jpcsp.HLE.kernel.types.SceLoadCoreExecFileInfo;
import jpcsp.HLE.kernel.types.SceModule;
import jpcsp.HLE.kernel.types.SceResidentLibraryEntryTable;
import jpcsp.HLE.kernel.types.SysMemThreadConfig;
import jpcsp.HLE.modules.SysMemUserForUser;
import jpcsp.HLE.modules.reboot;
import jpcsp.Memory;
import jpcsp.NIDMapper;
import jpcsp.format.Elf32Header;
import jpcsp.format.Elf32ProgramHeader;
import jpcsp.format.Elf32SectionHeader;
import jpcsp.format.PSPModuleInfo;
import jpcsp.util.HLEUtilities;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class LoadCoreForKernel
extends HLEModule {
    public static Logger log = Modules.getLogger("LoadCoreForKernel");
    private Set<Integer> dummyModuleData;
    private TPointer syscallStubAddr;
    private int availableSyscallStubs;
    private final Map<String, String> functionNames = new HashMap<String, String>();
    private final Map<Integer, Integer> functionNids = new HashMap<Integer, Integer>();
    private int loadCoreBaseAddress;
    private int threadManInfo;
    public int threadManInfoCurrentThreadOffset = 0;
    public int threadManInfoNextThreadOffset = 4;
    public int threadManInfoThreadTypeOffset;
    public int threadManInfoSleepingThreadsOffset;
    public int threadManInfoDelayedThreadsOffset;
    public int threadManInfoStoppedThreadsOffset;
    public int threadManInfoSuspendedThreadsOffset;
    public int threadManInfoDeadThreadsOffset;
    public int threadManInfoUnknownThreadsOffset;
    public int threadManInfoReadyThreadsOffset;
    private int syscallBaseAddress;

    public IAction getModuleStartAction() {
        return new OnModuleStartAction();
    }

    public int hleKernelCreateHeapHook(int partitionId, int size, int flags, String name) {
        if ("SceKernelLoadCore".equals(name) && partitionId == 1 && size == 4096 && flags == 1) {
            size += 16384;
        }
        return size;
    }

    public boolean decodeInitModuleData(TPointer buffer, int size, TPointer32 resultSize) {
        if (this.dummyModuleData == null || !this.dummyModuleData.contains(buffer.getAddress())) {
            return false;
        }
        buffer.memmove(buffer.getAddress() + 336, size - 336);
        resultSize.setValue(size - 336);
        return true;
    }

    private TPointer allocMem(int size) {
        SysMemUserForUser.SysMemInfo memInfo = Modules.SysMemUserForUserModule.malloc(1, "LoadCore-StartModuleParameters", 0, size, 0);
        if (memInfo == null) {
            log.error((Object)String.format("Cannot allocate memory for loadcore.prx start parameters", new Object[0]));
            return TPointer.NULL;
        }
        TPointer pointer = new TPointer(Memory.getInstance(), memInfo.addr);
        pointer.clear(size);
        return pointer;
    }

    private void freeMem(TPointer pointer) {
        SysMemUserForUser.SysMemInfo memInfo = Modules.SysMemUserForUserModule.getSysMemInfoByAddress(pointer.getAddress());
        if (memInfo != null) {
            Modules.SysMemUserForUserModule.free(memInfo);
        }
    }

    private int addSyscallStub(int syscallCode) {
        int stubSize = 8;
        if (this.availableSyscallStubs <= 0) {
            this.availableSyscallStubs = 128;
            this.syscallStubAddr = this.allocMem(this.availableSyscallStubs * 8);
            if (this.syscallStubAddr.isNull()) {
                this.availableSyscallStubs = 0;
                log.error((Object)String.format("No more free memory to create a new Syscall stub!", new Object[0]));
                return 0;
            }
        }
        int stubAddr = this.syscallStubAddr.getAddress();
        this.syscallStubAddr.setValue32(0, HLEUtilities.JR());
        this.syscallStubAddr.setValue32(4, HLEUtilities.SYSCALL(syscallCode));
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Adding a syscall 0x%X stub at 0x%08X", syscallCode, stubAddr));
        }
        this.syscallStubAddr.add(8);
        --this.availableSyscallStubs;
        return stubAddr;
    }

    private TPointer createDummyModule(SceLoadCoreBootModuleInfo sceLoadCoreBootModuleInfo, String moduleName, int initCodeOffset) {
        int moduleInfoSizeof = new PSPModuleInfo().sizeof();
        int initCodeSize = 8;
        int totalSize = 400 + Elf32Header.sizeof() + Elf32ProgramHeader.sizeof() + Elf32SectionHeader.sizeof() + moduleInfoSizeof + initCodeOffset + 8;
        TPointer modBuf = this.allocMem(totalSize);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Allocated dummy module buffer %s", modBuf));
        }
        sceLoadCoreBootModuleInfo.modBuf = modBuf;
        int offset = 0;
        modBuf.setValue32(offset + 0, 1162040190);
        modBuf.setValue32(offset + 4, 64);
        this.dummyModuleData.add(modBuf.getAddress() + (offset += 64));
        modBuf.setValue32(offset + 0, 1347637374);
        modBuf.setValue16(offset + 4, (short)4096);
        modBuf.setValue32(offset + 44, totalSize - 64);
        modBuf.setValue32(offset + 48, 0);
        modBuf.setValue32(offset + 52, Integer.MIN_VALUE + Elf32Header.sizeof() + Elf32ProgramHeader.sizeof() + Elf32SectionHeader.sizeof());
        modBuf.setValue8(offset + 124, (byte)2);
        modBuf.setValue32(offset + 208, 0);
        modBuf.setValue32((offset += 336) + 0, 1179403647);
        modBuf.setValue8(offset + 4, (byte)1);
        modBuf.setValue8(offset + 5, (byte)1);
        modBuf.setValue16(offset + 16, (short)-96);
        modBuf.setValue16(offset + 18, (short)8);
        modBuf.setValue32(offset + 24, moduleInfoSizeof + initCodeOffset);
        modBuf.setValue32(offset + 28, Elf32Header.sizeof());
        modBuf.setValue32(offset + 32, Elf32Header.sizeof() + Elf32ProgramHeader.sizeof());
        modBuf.setValue16(offset + 44, (short)1);
        modBuf.setValue16(offset + 48, (short)1);
        modBuf.setValue16(offset + 50, (short)0);
        modBuf.setValue32((offset += Elf32Header.sizeof()) + 0, 1);
        modBuf.setValue32(offset + 4, Elf32Header.sizeof() + Elf32ProgramHeader.sizeof() + Elf32SectionHeader.sizeof());
        modBuf.setValue32(offset + 8, 0);
        modBuf.setValue32(offset + 12, Elf32Header.sizeof() + Elf32ProgramHeader.sizeof() + Elf32SectionHeader.sizeof());
        modBuf.setValue32(offset + 16, moduleInfoSizeof + initCodeOffset + 8);
        modBuf.setValue32(offset + 20, moduleInfoSizeof + initCodeOffset + 8);
        modBuf.setValue32((offset += Elf32ProgramHeader.sizeof()) + 4, 1);
        modBuf.setValue32(offset + 8, 6);
        modBuf.setValue32(offset + 16, 1);
        modBuf.setValue32(offset + 20, 0);
        modBuf.setStringNZ((offset += Elf32SectionHeader.sizeof()) + 4, 28, moduleName);
        offset += new PSPModuleInfo().sizeof();
        TPointer entryPointCode = new TPointer(modBuf, offset += initCodeOffset);
        modBuf.setValue32(offset + 0, HLEUtilities.JR());
        modBuf.setValue32(offset + 4, HLEUtilities.ADDIU(2, 0, 0));
        offset += 8;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("createDummyModule moduleName='%s', entryPointCode=%s", moduleName, entryPointCode));
        }
        return entryPointCode;
    }

    private void createDummyInitModule(SceLoadCoreBootModuleInfo sceLoadCoreBootModuleInfo) {
        TPointer entryPointCode = this.createDummyModule(sceLoadCoreBootModuleInfo, "sceInit", 4);
        entryPointCode.setValue32(4, HLEUtilities.SYSCALL(this, "hleLoadCoreInitStart"));
    }

    private void addKernelUserLibs(SysMemThreadConfig sysMemThreadConfig, String libName, int[] nids) {
        TPointer entryTable;
        SceResidentLibraryEntryTable sceResidentLibraryEntryTable = new SceResidentLibraryEntryTable();
        sceResidentLibraryEntryTable.libNameAddr = this.allocMem(libName.length() + 1);
        sceResidentLibraryEntryTable.libNameAddr.setStringZ(libName);
        sceResidentLibraryEntryTable.version[0] = 17;
        sceResidentLibraryEntryTable.attribute = 1;
        sceResidentLibraryEntryTable.len = 5;
        sceResidentLibraryEntryTable.vStubCount = 0;
        sceResidentLibraryEntryTable.stubCount = 0;
        sceResidentLibraryEntryTable.vStubCountNew = 0;
        int[] addresses = new int[nids.length];
        boolean[] areVariableExports = new boolean[nids.length];
        TPointer sceResidentLibraryEntryTableAddr = this.allocMem(sceResidentLibraryEntryTable.sizeof() + nids.length * 8);
        sceResidentLibraryEntryTable.entryTable = entryTable = new TPointer(sceResidentLibraryEntryTableAddr, sceResidentLibraryEntryTable.sizeof());
        NIDMapper nidMapper = NIDMapper.getInstance();
        for (int i = 0; i < nids.length; ++i) {
            int syscallCode;
            int nid = nids[i];
            int address = nidMapper.getAddressByNid(nid, libName);
            if (address == 0 && (syscallCode = nidMapper.getSyscallByNid(nid)) >= 0) {
                address = this.addSyscallStub(syscallCode);
            }
            boolean isVariableExport = nidMapper.isVariableExportByAddress(address);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Registering library '%s' NID 0x%08X at address 0x%08X (variableExport=%b)", libName, nid, address, isVariableExport));
            }
            addresses[i] = address;
            areVariableExports[i] = isVariableExport;
            if (isVariableExport) {
                ++sceResidentLibraryEntryTable.vStubCountNew;
                continue;
            }
            ++sceResidentLibraryEntryTable.stubCount;
        }
        sceResidentLibraryEntryTable.write(sceResidentLibraryEntryTableAddr);
        int functionIndex = 0;
        int variableIndex = sceResidentLibraryEntryTable.stubCount;
        for (int i = 0; i < nids.length; ++i) {
            int index = areVariableExports[i] ? variableIndex++ : functionIndex++;
            entryTable.setValue32(index * 4, nids[i]);
            entryTable.setValue32((index + nids.length) * 4, addresses[i]);
        }
        int userLibIndex = sysMemThreadConfig.numExportLibs - sysMemThreadConfig.numKernelLibs;
        if (userLibIndex == sysMemThreadConfig.userLibs.length) {
            sysMemThreadConfig.userLibs = Utilities.extendArray(sysMemThreadConfig.userLibs, 1);
        }
        sysMemThreadConfig.userLibs[userLibIndex] = sceResidentLibraryEntryTableAddr;
        ++sysMemThreadConfig.numExportLibs;
    }

    private void addKernelUserLibs(SysMemThreadConfig sysMemThreadConfig, String libName) {
        if ("LoadCoreForKernel".equals(libName)) {
            return;
        }
        int[] nids = NIDMapper.getInstance().getModuleNids(libName);
        if (nids == null) {
            log.warn((Object)String.format("Unknown library '%s', no NIDs found", libName));
            return;
        }
        Arrays.sort(nids);
        this.addKernelUserLibs(sysMemThreadConfig, libName, nids);
    }

    private void prepareKernelLibs(SysMemThreadConfig sysMemThreadConfig) {
        String[] moduleNames;
        for (String moduleName : moduleNames = NIDMapper.getInstance().getModuleNames()) {
            this.addKernelUserLibs(sysMemThreadConfig, moduleName);
        }
    }

    private void addExistingModule(SceLoadCoreBootInfo sceLoadCoreBootInfo, String moduleName) {
        SceModule module = Managers.modules.getModuleByName(moduleName);
        if (module == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("addExistingModule could not find module '%s'", moduleName));
            }
            return;
        }
        SceLoadCoreBootModuleInfo sceLoadCoreBootModuleInfo = new SceLoadCoreBootModuleInfo();
        this.createDummyModule(sceLoadCoreBootModuleInfo, moduleName, 0);
        TPointer sceLoadCoreBootModuleInfoAddr = new TPointer(sceLoadCoreBootInfo.startAddr, sceLoadCoreBootInfo.numModules * sceLoadCoreBootModuleInfo.sizeof());
        sceLoadCoreBootModuleInfo.write(sceLoadCoreBootModuleInfoAddr);
        ++sceLoadCoreBootInfo.numModules;
    }

    @HLEFunction(nid=-1, version=150)
    public int hleLoadCoreInitStart(int argc, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=128, usage=BufferInfo.Usage.in) TPointer sceLoadCoreBootInfoAddr) {
        SceLoadCoreBootInfo sceLoadCoreBootInfo = new SceLoadCoreBootInfo();
        sceLoadCoreBootInfo.read(sceLoadCoreBootInfoAddr);
        int sceKernelFindModuleByName = NIDMapper.getInstance().getAddressByName("sceKernelFindModuleByName");
        if (sceKernelFindModuleByName != 0) {
            SceKernelThreadInfo thread = Modules.ThreadManForUserModule.getCurrentThread();
            String moduleName = "scePaf_Module";
            TPointer moduleNameAddr = this.allocMem(moduleName.length() + 1);
            moduleNameAddr.setStringZ(moduleName);
            Modules.ThreadManForUserModule.executeCallback(thread, sceKernelFindModuleByName, (IAction)new AfterSceKernelFindModuleByName(thread, moduleNameAddr), false, moduleNameAddr.getAddress());
        }
        return 0;
    }

    private void fixExistingModule(TPointer moduleNameAddr, int sceModuleAddr) {
        SceModule sceModule;
        String moduleName = moduleNameAddr.getStringZ();
        Memory mem = moduleNameAddr.getMemory();
        this.freeMem(moduleNameAddr);
        if (sceModuleAddr != 0 && (sceModule = Managers.modules.getModuleByName(moduleName)) != null) {
            mem.write32(sceModuleAddr + 108, sceModule.text_addr);
            mem.write32(sceModuleAddr + 112, sceModule.text_size);
            mem.write32(sceModuleAddr + 116, sceModule.data_size);
            mem.write32(sceModuleAddr + 120, sceModule.bss_size);
        }
    }

    private void onModuleStart() {
        TPointer dummySegmentAddr;
        this.dummyModuleData = new HashSet<Integer>();
        SceLoadCoreBootInfo sceLoadCoreBootInfo = new SceLoadCoreBootInfo();
        SysMemThreadConfig sysMemThreadConfig = new SysMemThreadConfig();
        SceLoadCoreExecFileInfo loadCoreExecInfo = new SceLoadCoreExecFileInfo();
        SceLoadCoreExecFileInfo sysMemExecInfo = new SceLoadCoreExecFileInfo();
        PSPModuleInfo loadCoreModuleInfo = new PSPModuleInfo();
        PSPModuleInfo sysMemModuleInfo = new PSPModuleInfo();
        this.prepareKernelLibs(sysMemThreadConfig);
        int dummySegmentSize = 64;
        loadCoreExecInfo.segmentAddr[0] = dummySegmentAddr = this.allocMem(dummySegmentSize);
        loadCoreExecInfo.segmentSize[0] = dummySegmentSize;
        loadCoreExecInfo.numSegments = 1;
        sysMemExecInfo.segmentAddr[0] = dummySegmentAddr;
        sysMemExecInfo.segmentSize[0] = dummySegmentSize;
        sysMemExecInfo.numSegments = 1;
        int totalNumberOfModules = 2;
        SceLoadCoreBootModuleInfo sceLoadCoreBootModuleInfo = new SceLoadCoreBootModuleInfo();
        sceLoadCoreBootInfo.startAddr = this.allocMem(2 * sceLoadCoreBootModuleInfo.sizeof());
        sceLoadCoreBootInfo.numModules = 0;
        this.addExistingModule(sceLoadCoreBootInfo, "scePaf_Module");
        this.createDummyInitModule(sceLoadCoreBootModuleInfo);
        TPointer sceLoadCoreBootModuleInfoAddr = new TPointer(sceLoadCoreBootInfo.startAddr, sceLoadCoreBootInfo.numModules * sceLoadCoreBootModuleInfo.sizeof());
        sceLoadCoreBootModuleInfo.write(sceLoadCoreBootModuleInfoAddr);
        ++sceLoadCoreBootInfo.numModules;
        TPointer loadCoreModuleInfoAddr = this.allocMem(loadCoreModuleInfo.sizeof());
        loadCoreModuleInfo.write(loadCoreModuleInfoAddr);
        loadCoreExecInfo.moduleInfo = loadCoreModuleInfoAddr;
        TPointer sysMemModuleInfoAddr = this.allocMem(sysMemModuleInfo.sizeof());
        sysMemModuleInfo.write(sysMemModuleInfoAddr);
        sysMemExecInfo.moduleInfo = sysMemModuleInfoAddr;
        TPointer sysMemExecInfoAddr = this.allocMem(sysMemExecInfo.sizeof());
        sysMemExecInfo.write(sysMemExecInfoAddr);
        sysMemThreadConfig.sysMemExecInfo = sysMemExecInfoAddr;
        TPointer loadCoreExecInfoAddr = this.allocMem(loadCoreExecInfo.sizeof());
        loadCoreExecInfo.write(loadCoreExecInfoAddr);
        sysMemThreadConfig.loadCoreExecInfo = loadCoreExecInfoAddr;
        TPointer sceLoadCoreBootInfoAddr = this.allocMem(sceLoadCoreBootInfo.sizeof());
        sceLoadCoreBootInfo.write(sceLoadCoreBootInfoAddr);
        TPointer sysMemThreadConfigAddr = this.allocMem(sysMemThreadConfig.sizeof());
        sysMemThreadConfig.write(sysMemThreadConfigAddr);
        TPointer argp = this.allocMem(8);
        argp.setPointer(0, sceLoadCoreBootInfoAddr);
        argp.setPointer(4, sysMemThreadConfigAddr);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("onModuleStart sceLoadCoreBootInfoAddr=%s, sysMemThreadConfigAddr=%s, loadCoreExecInfoAddr=%s, sysMemExecInfoAddr=%s", sceLoadCoreBootInfoAddr, sysMemThreadConfigAddr, loadCoreExecInfoAddr, sysMemExecInfoAddr));
        }
        SceKernelThreadInfo currentThread = Modules.ThreadManForUserModule.getCurrentThread();
        currentThread.cpuContext._a0 = 8;
        currentThread.cpuContext._a1 = argp.getAddress();
    }

    private int scanForLoadConstantValueIntoRegister(Memory mem, int addr, int reg) {
        int value = 0;
        int baseRegister = -1;
        int offsetLow = 0;
        for (int i = 4; i < 300; i += 4) {
            int opcode = mem.internalRead32(addr - i);
            if (opcode >>> 26 == 9 && (opcode >> 16 & 0x1F) == reg) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Found addiu at 0x%08X", addr - i));
                }
                baseRegister = opcode >> 21 & 0x1F;
                offsetLow = opcode & 0xFFFF;
                continue;
            }
            if (opcode >>> 26 != 15 || (opcode >> 16 & 0x1F) != baseRegister) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Found lui at 0x%08X", addr - i));
            }
            int offsetHigh = opcode & 0xFFFF;
            value = (offsetHigh << 16) + (short)offsetLow;
            if (!log.isDebugEnabled()) break;
            log.debug((Object)String.format("Found constant value=0x%08X", value));
            break;
        }
        return value;
    }

    private int getLoadCoreBaseAddress() {
        if (this.loadCoreBaseAddress == 0) {
            Memory mem = Memory.getInstance();
            if (log.isDebugEnabled()) {
                log.debug((Object)"Searching for the loadCodeBaseAddress");
            }
            int swOpcode = HLEUtilities.SW(0, 4, 524);
            if (RuntimeContextLLE.getFirmwareVersion() <= 201) {
                swOpcode = HLEUtilities.SW(0, 5, 20);
            }
            for (int i = 77824; i < 98304 && this.loadCoreBaseAddress == 0; i += 4) {
                int addr = -2013265920 + i;
                if (mem.internalRead32(addr) != swOpcode) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Found sw at 0x%08X", addr));
                }
                int register = swOpcode >> 21 & 0x1F;
                this.loadCoreBaseAddress = this.scanForLoadConstantValueIntoRegister(mem, addr, register);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)String.format("Found loadCoreBaseAddress=0x%08X", this.loadCoreBaseAddress));
            }
        }
        return this.loadCoreBaseAddress;
    }

    private int getSyscallBaseAddress() {
        if (this.syscallBaseAddress == 0) {
            Memory mem = Memory.getInstance();
            int ebase = RuntimeContextLLE.getProcessor().cp0.getEbase();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Found ebase=0x%08X", ebase));
            }
            for (int i = 0; i < 100; i += 4) {
                int opcode = mem.internalRead32(ebase + i);
                if (opcode >>> 26 != 2) continue;
                int addr = ebase & 0xF0000000 | (opcode & 0x3FFFFFF) << 2;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Found jump instruction to 0x%08X at 0x%08X", addr, ebase + i));
                }
                for (int j = 0; j < 100 && this.syscallBaseAddress == 0; j += 4) {
                    opcode = mem.internalRead32(addr + j);
                    if (opcode >>> 26 != 0 || (opcode & 0x3F) != 8) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Found jr instruction at 0x%08X", addr + j));
                    }
                    int jumpRegister = opcode >> 21 & 0x1F;
                    int offsetLow = 0;
                    int baseRegister = -1;
                    for (int k = 4; k < 100 && this.syscallBaseAddress == 0; k += 4) {
                        opcode = mem.internalRead32(addr + j - k);
                        if (opcode >>> 26 == 35 && (opcode >> 16 & 0x1F) == jumpRegister) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)String.format("Found lw at 0x%08X", addr + j - k));
                            }
                            baseRegister = opcode >> 21 & 0x1F;
                            offsetLow = opcode & 0xFFFF;
                            continue;
                        }
                        if (opcode >>> 26 != 15 || (opcode >> 16 & 0x1F) != baseRegister) continue;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Found lui at 0x%08X", addr + j - k));
                        }
                        int offsetHigh = opcode & 0xFFFF;
                        this.syscallBaseAddress = (offsetHigh << 16) + (short)offsetLow;
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)String.format("Found syscallBaseAddress=0x%08X", this.syscallBaseAddress));
                    }
                }
            }
        }
        return this.syscallBaseAddress;
    }

    private int getRegisteredModules(Memory mem) {
        int g_loadCore = this.getLoadCoreBaseAddress();
        if (g_loadCore == 0) {
            return 0;
        }
        int registeredModulesOffset = RuntimeContextLLE.getFirmwareVersion() <= 201 ? 20 : (RuntimeContextLLE.getFirmwareVersion() < 300 ? 528 : 524);
        int registeredModules = mem.internalRead32(g_loadCore + registeredModulesOffset);
        return registeredModules;
    }

    public int getThreadManInfo() {
        Memory mem;
        int registeredMods;
        if (this.threadManInfo == 0 && (registeredMods = this.getRegisteredModules(mem = Memory.getInstance())) != 0) {
            int threadManModule;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Searching for the threadManInfo");
            }
            if ((threadManModule = this.getModuleByName(mem, registeredMods, "sceThreadManager")) != 0) {
                int moduleBootStart = mem.internalRead32(threadManModule + 88);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Found sceThreadManager.module_bootstart=0x%08X", moduleBootStart));
                }
                block0: for (int i = 0; i < 200 && this.threadManInfo == 0; i += 4) {
                    int j;
                    int addr = moduleBootStart + i;
                    int opcode = mem.internalRead32(addr);
                    if (opcode >>> 26 != 0 || (opcode & 0x3F) != 33 || (opcode >> 11 & 0x1F) != 4 || (opcode >> 16 & 0x1F) != 0) continue;
                    int valueRegister = opcode >> 21 & 0x1F;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Found addu at 0x%08X", addr));
                    }
                    this.threadManInfo = this.scanForLoadConstantValueIntoRegister(mem, addr, valueRegister);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Found threadManInfo=0x%08X", this.threadManInfo));
                    }
                    int lastOffset = addr;
                    int[] offsets = null;
                    int wantedNumberOfOffsets = 6;
                    for (j = 0; j < 200; j += 4) {
                        opcode = mem.internalRead32(addr + j);
                        if (opcode >>> 26 != 9 || (opcode >> 21 & 0x1F) != valueRegister) continue;
                        short offset = (short)(opcode & 0xFFFF);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Found addiu with offset %d at 0x%08X", offset, addr + j));
                        }
                        offsets = Utilities.add(offsets, offset);
                        lastOffset = addr + j;
                        if (offsets.length >= 6) break;
                    }
                    if (offsets != null && offsets.length >= 6) {
                        Arrays.sort(offsets);
                        int n = 0;
                        this.threadManInfoReadyThreadsOffset = offsets[n++];
                        this.threadManInfoSleepingThreadsOffset = offsets[n++];
                        this.threadManInfoDelayedThreadsOffset = offsets[n++];
                        this.threadManInfoStoppedThreadsOffset = offsets[n++];
                        this.threadManInfoSuspendedThreadsOffset = offsets[n++];
                        this.threadManInfoDeadThreadsOffset = offsets[n++];
                        this.threadManInfoUnknownThreadsOffset = RuntimeContextLLE.getFirmwareVersion() >= 660 ? this.threadManInfoDeadThreadsOffset + 8 : -1;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Found threadManInfoReadyThreadsOffset=%d", this.threadManInfoReadyThreadsOffset));
                            log.debug((Object)String.format("Found threadManInfoSleepingThreadsOffset=%d", this.threadManInfoSleepingThreadsOffset));
                            log.debug((Object)String.format("Found threadManInfoDelayedThreadsOffset=%d", this.threadManInfoDelayedThreadsOffset));
                            log.debug((Object)String.format("Found threadManInfoStoppedThreadsOffset=%d", this.threadManInfoStoppedThreadsOffset));
                            log.debug((Object)String.format("Found threadManInfoSuspendedThreadsOffset=%d", this.threadManInfoSuspendedThreadsOffset));
                            log.debug((Object)String.format("Found threadManInfoDeadThreadsOffset=%d", this.threadManInfoDeadThreadsOffset));
                            log.debug((Object)String.format("Found threadManInfoUnknownThreadsOffset=%d", this.threadManInfoUnknownThreadsOffset));
                        }
                    }
                    this.threadManInfoThreadTypeOffset = -1;
                    opcode = HLEUtilities.ADDIU(5, 0, 2048);
                    for (j = 0; j < 200; j += 4) {
                        if (mem.internalRead32(lastOffset + j) != opcode) continue;
                        for (int k = 0; k < 200; k += 4) {
                            opcode = mem.internalRead32(lastOffset + j + k);
                            if (opcode >>> 26 != 35 || (opcode >> 16 & 0x1F) != 4) continue;
                            this.threadManInfoThreadTypeOffset = (short)(opcode & 0xFFFF);
                            if (!log.isDebugEnabled()) continue block0;
                            log.debug((Object)String.format("Found threadManInfoThreadTypeOffset=%d", this.threadManInfoThreadTypeOffset));
                            continue block0;
                        }
                        continue block0;
                    }
                }
            }
        }
        return this.threadManInfo;
    }

    public HLEModuleFunction getHLEFunctionByAddress(int address) {
        if (!reboot.enableReboot) {
            return null;
        }
        address &= 0x1FFFFFFF;
        Memory mem = Memory.getInstance();
        int g_loadCore = this.getLoadCoreBaseAddress();
        if (g_loadCore == 0) {
            return null;
        }
        int registeredLibs = g_loadCore + 0;
        int[] nids = this.getFunctionNIDsByAddress(mem, registeredLibs, address);
        if (nids == null && Memory.isAddressGood(address) && mem.internalRead32(address) >>> 26 == 2 && mem.internalRead32(address + 4) == HLEUtilities.NOP()) {
            int jumpAddress = (mem.internalRead32(address) & 0x3FFFFFF) << 2;
            nids = this.getFunctionNIDsByAddress(mem, registeredLibs, jumpAddress);
        }
        if (nids != null) {
            for (int nid : nids) {
                HLEModuleFunction hleFunction = HLEModuleManager.getInstance().getFunctionFromNID(nid);
                if (hleFunction == null) continue;
                return hleFunction;
            }
        }
        return null;
    }

    public String getFunctionNameBySyscall(Memory mem, int syscallCode) {
        if (!reboot.loadCoreInitialized) {
            return null;
        }
        int address = 0;
        int syscallIndex = syscallCode << 2;
        if (syscallIndex < 256) {
            int syscallBaseAddres = this.getSyscallBaseAddress();
            if (syscallBaseAddres == 0) {
                return null;
            }
            address = mem.read32(syscallBaseAddres + syscallIndex);
        } else {
            int syscallTable = Emulator.getProcessor().cp0.getSyscallTable();
            while (syscallTable != 0) {
                int baseSyscallIndex = mem.read32(syscallTable + 4);
                int tableSize = mem.read32(syscallTable + 8);
                if (syscallIndex >= baseSyscallIndex && syscallIndex < baseSyscallIndex + tableSize) {
                    address = mem.read32(syscallTable + 16 + syscallIndex - baseSyscallIndex);
                    break;
                }
                syscallTable = mem.read32(syscallTable + 0);
            }
        }
        return this.getFunctionNameByAddress(mem, address);
    }

    public String getFunctionNameByAddress(Memory mem, int address) {
        int syscallCode;
        if (!reboot.loadCoreInitialized || (address & 0x1FFFFFFF) == 0) {
            return null;
        }
        String functionName = null;
        int nextOpcode = Emulator.getMemory(address).internalRead32(address + 4);
        Common.Instruction nextInsn = Decoder.instruction(nextOpcode);
        if (nextInsn == Instructions.SYSCALL && (functionName = this.getFunctionNameBySyscall(mem, syscallCode = nextOpcode >> 6 & 0xFFFFF)) != null) {
            return functionName;
        }
        HLEModuleFunction hleModuleFunction = this.getHLEFunctionByAddress(address);
        if (hleModuleFunction != null) {
            return hleModuleFunction.getFunctionName();
        }
        int registeredMods = this.getRegisteredModules(mem);
        if (registeredMods == 0) {
            return null;
        }
        int module = this.getModuleByAddress(mem, registeredMods, address &= 0x1FFFFFFF);
        if (module != 0) {
            String moduleName = Utilities.readInternalStringNZ(mem, module + 8, 27);
            int moduleStart = mem.internalRead32(module + 80) & 0x1FFFFFFF;
            int moduleStop = mem.internalRead32(module + 84) & 0x1FFFFFFF;
            int moduleBootStart = mem.internalRead32(module + 88) & 0x1FFFFFFF;
            int moduleRebootBefore = mem.internalRead32(module + 92) & 0x1FFFFFFF;
            int moduleRebootPhase = mem.internalRead32(module + 96) & 0x1FFFFFFF;
            int entryAddr = mem.internalRead32(module + 100) & 0x1FFFFFFF;
            int textAddr = mem.internalRead32(module + 108) & 0x1FFFFFFF;
            functionName = address == moduleStart ? String.format("%s.module_start", moduleName) : (address == moduleStop ? String.format("%s.module_stop", moduleName) : (address == moduleBootStart ? String.format("%s.module_bootstart", moduleName) : (address == moduleRebootBefore ? String.format("%s.module_reboot_before", moduleName) : (address == moduleRebootPhase ? String.format("%s.module_reboot_phase", moduleName) : (address == entryAddr ? String.format("%s.module_start", moduleName) : String.format("%s.sub_%08X", moduleName, address - textAddr))))));
        }
        if (functionName != null && this.functionNames.containsKey(functionName)) {
            functionName = this.functionNames.get(functionName);
        }
        return functionName;
    }

    public void addFunctionName(String moduleName, int address, String functionName) {
        this.functionNames.put(String.format("%s.sub_%08X", moduleName, address), functionName);
    }

    public void addFunctionNid(int address, int nid) {
        this.functionNids.put(address &= 0x1FFFFFFF, nid);
    }

    private int[] getFunctionNIDsByAddress(Memory mem, int registeredLibs, int address) {
        int[] nids = null;
        int firmwareVersion = RuntimeContextLLE.getFirmwareVersion();
        int registeredLibsEntries = firmwareVersion <= 201 ? 1 : 128;
        for (int i = 0; i < registeredLibsEntries; ++i) {
            int linkedLibraries = mem.internalRead32(registeredLibs + i * 4);
            while (linkedLibraries != 0) {
                int entryTable;
                int numExports;
                if (firmwareVersion < 260) {
                    numExports = mem.internalRead16(linkedLibraries + 14);
                    entryTable = mem.internalRead32(linkedLibraries + 16);
                } else {
                    numExports = mem.internalRead32(linkedLibraries + 16);
                    entryTable = mem.internalRead32(linkedLibraries + 32);
                }
                for (int j = 0; j < numExports; ++j) {
                    int nid = mem.internalRead32(entryTable + j * 4);
                    int entryAddress = mem.internalRead32(entryTable + (j + numExports) * 4) & 0x1FFFFFFF;
                    if (address != entryAddress) continue;
                    nids = Utilities.add(nids, nid);
                }
                linkedLibraries = mem.internalRead32(linkedLibraries);
            }
        }
        if (nids == null && this.functionNids.containsKey(address)) {
            nids = new int[]{this.functionNids.get(address)};
        }
        return nids;
    }

    private int getModuleByName(Memory mem, int linkedModules, String name) {
        while (linkedModules != 0 && Memory.isAddressGood(linkedModules)) {
            String moduleName = Utilities.readInternalStringNZ(mem, linkedModules + 8, 27);
            if (name.equals(moduleName)) {
                return linkedModules;
            }
            linkedModules = mem.internalRead32(linkedModules + 0);
        }
        return 0;
    }

    private int getModuleByAddress(Memory mem, int linkedModules, int address) {
        while (linkedModules != 0 && Memory.isAddressGood(linkedModules)) {
            int textAddr = mem.internalRead32(linkedModules + 108) & 0x1FFFFFFF;
            int textSize = mem.internalRead32(linkedModules + 112);
            if (textAddr <= address && address < textAddr + textSize) {
                return linkedModules;
            }
            linkedModules = mem.internalRead32(linkedModules + 0);
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1394461578, version=150)
    public int sceKernelCheckPspConfig() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1260978484, version=150)
    public int sceKernelApplyElfRelSection() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1420502645, version=150)
    public int sceKernelApplyPspRelSection() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=693302700, version=150)
    public int sceKernelDcacheWBinvAll() {
        return 0;
    }

    @HLELogging(level="trace")
    @HLEFunction(nid=-663250234, version=150)
    public int sceKernelIcacheClearAll() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-912403334, version=150)
    public int sceKernelQueryLoadCoreCB() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1634716877, version=150)
    public int sceKernelSetBootCallbackLevel() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1342617644, version=150)
    public int sceKernelCreateAssignModule() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=-1367576970, version=150), @HLEFunction(nid=-1087489908, version=660)})
    public int sceKernelRegisterModule(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=228, usage=BufferInfo.Usage.inout) TPointer module) {
        return 0;
    }

    @HLEFunctions(value={@HLEFunction(nid=-813022799, version=150), @HLEFunction(nid=-156123377, version=660)})
    public int sceKernelFindModuleByName(PspString moduleName) {
        SceModule module = Managers.modules.getModuleByName(moduleName.getString());
        if (module == null) {
            log.warn((Object)String.format("sceKernelFindModuleByName not found moduleName=%s", moduleName));
            return 0;
        }
        if (!Modules.ThreadManForUserModule.isKernelMode()) {
            log.warn((Object)"kernel mode required (sceKernelFindModuleByName)");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelFindModuleByName returning 0x%08X", module.address));
        }
        return module.address;
    }

    @HLEFunctions(value={@HLEFunction(nid=-74784131, version=150), @HLEFunction(nid=-1130772955, version=660)})
    public int sceKernelFindModuleByAddress(TPointer address) {
        SceModule module = Managers.modules.getModuleByAddress(address.getAddress());
        if (module == null) {
            log.warn((Object)String.format("sceKernelFindModuleByAddress not found module address=%s", address));
            return 0;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelFindModuleByAddress found module '%s'", module.modname));
        }
        if (!Modules.ThreadManForUserModule.isKernelMode()) {
            log.warn((Object)"kernel mode required (sceKernelFindModuleByAddress)");
        }
        return module.address;
    }

    @HLEFunctions(value={@HLEFunction(nid=-857431721, version=150), @HLEFunction(nid=1083649646, version=660)})
    public int sceKernelFindModuleByUID(int uid) {
        SceModule module = Managers.modules.getModuleByUID(uid);
        if (module == null) {
            log.warn((Object)String.format("sceKernelFindModuleByUID not found module uid=0x%X", uid));
            return 0;
        }
        if (RuntimeContext.isHomebrew()) {
            String[] bannedModules;
            for (String bannedModule : bannedModules = new String[]{"sceNet_Library", "sceNetInet_Library", "sceNetApctl_Library", "sceNetResolver_Library"}) {
                if (!bannedModule.equals(module.modname)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceKernelFindModuleByUID banning module '%s' for a homebrew", module.modname));
                }
                return 0;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelFindModuleByUID found module '%s'", module.modname));
        }
        if (!Modules.ThreadManForUserModule.isKernelMode()) {
            log.warn((Object)"kernel mode required (sceKernelFindModuleByUID)");
        }
        return module.address;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1300446652, version=150)
    public int sceKernelLoadRebootBin(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.in) TPointer fileData, int fileSize) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1228859265, version=660)
    public int sceKernelLoadModuleBootLoadCore(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=32, usage=BufferInfo.Usage.in) TPointer bootModInfo, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=192, usage=BufferInfo.Usage.out) TPointer execInfo, @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 modMemId) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=2078360092, version=150), @HLEFunction(nid=-751485244, version=660)})
    public int sceKernelCheckExecFile(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=256, usage=BufferInfo.Usage.in) TPointer buf, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=192, usage=BufferInfo.Usage.inout) TPointer execInfo) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=-1080541454, version=150), @HLEFunction(nid=1104218265, version=660)})
    public int sceKernelProbeExecutableObject(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=256, usage=BufferInfo.Usage.in) TPointer buf, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=192, usage=BufferInfo.Usage.inout) TPointer execInfo) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=1885923002, version=150), @HLEFunction(nid=473516165, version=660)})
    public int sceKernelLoadExecutableObject(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=256, usage=BufferInfo.Usage.in) TPointer buf, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=192, usage=BufferInfo.Usage.inout) TPointer execInfo) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=-1717135888, version=150), @HLEFunction(nid=1219466921, version=660)})
    public int sceKernelRegisterLibrary(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=20, usage=BufferInfo.Usage.in) TPointer libEntryTable) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=-1682992906, version=150), @HLEFunction(nid=1400973816, version=660)})
    public int sceKernelCanReleaseLibrary(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=20, usage=BufferInfo.Usage.in) TPointer libEntryTable) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=242617786, version=150), @HLEFunction(nid=-1901161164, version=660)})
    public int sceKernelLinkLibraryEntries(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=26, usage=BufferInfo.Usage.in) TPointer libEntryTable, int size) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=-635762262, version=150), @HLEFunction(nid=43372494, version=660)})
    public int sceKernelUnLinkLibraryEntries(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=26, usage=BufferInfo.Usage.in) TPointer libEntryTable, int size) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=429458223, version=660)
    public int sceKernelLoadCoreLock() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1228916758, version=660)
    public int sceKernelLoadCoreUnlock(int intrState) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=1483973407, version=150), @HLEFunction(nid=744541368, version=660)})
    public int sceKernelRegisterLibraryForUser(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=26, usage=BufferInfo.Usage.in) TPointer libEntryTable) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=189154578, version=150), @HLEFunction(nid=-882677104, version=660)})
    public int sceKernelReleaseLibrary(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=26, usage=BufferInfo.Usage.in) TPointer libEntryTable) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=232912384, version=150), @HLEFunction(nid=1859125178, version=660)})
    public int sceKernelLinkLibraryEntriesForUser(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.in) TPointer libStubTable, int size) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1534991602, version=660)
    public int sceKernelLinkLibraryEntriesWithModule(TPointer mod, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.in) TPointer libStubTable, int size) {
        return 0;
    }

    @HLEFunction(nid=420836223, version=660)
    public int sceKernelMaskLibraryEntries() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=1797484994, version=150), @HLEFunction(nid=1791931, version=660)})
    public int sceKernelDeleteModule(TPointer mod) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=-854639700, version=150), @HLEFunction(nid=742717331, version=660)})
    public int sceKernelCreateModule() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=98112987, version=150), @HLEFunction(nid=937882651, version=660)})
    public int sceKernelGetModuleIdListForKernel(TPointer32 modIdList, int size, TPointer32 modCount, boolean userModsOnly) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=-1835312023, version=150), @HLEFunction(nid=1072050672, version=660)})
    public int sceKernelGetModuleListWithAlloc(TPointer32 modCount) {
        return 0;
    }

    @HLEFunction(nid=1090553081, version=660)
    public int sceKernelGetModuleGPByAddressForKernel(int addr) {
        return Managers.modules.getModuleGpByAddress(addr);
    }

    @HLEUnimplemented
    @HLEFunction(nid=1608364154, version=660)
    public int sceKernelSegmentChecksum(TPointer mod) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=1959723034, version=150), @HLEFunction(nid=-1317056395, version=660)})
    public int sceKernelReleaseModule(TPointer mod) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=1386769441, version=150), @HLEFunction(nid=-853090102, version=660)})
    public int sceKernelGetModuleFromUID(int uid) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=-1920300338, version=150), @HLEFunction(nid=-203601912, version=660)})
    public int sceKernelAssignModule(TPointer mod, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=192, usage=BufferInfo.Usage.inout) TPointer execFileInfo) {
        return 0;
    }

    private class AfterSceKernelFindModuleByName
    implements IAction {
        private SceKernelThreadInfo thread;
        private TPointer moduleNameAddr;

        public AfterSceKernelFindModuleByName(SceKernelThreadInfo thread, TPointer moduleNameAddr) {
            this.thread = thread;
            this.moduleNameAddr = moduleNameAddr;
        }

        @Override
        public void execute() {
            LoadCoreForKernel.this.fixExistingModule(this.moduleNameAddr, this.thread.cpuContext._v0);
        }
    }

    private class OnModuleStartAction
    implements IAction {
        private OnModuleStartAction() {
        }

        @Override
        public void execute() {
            LoadCoreForKernel.this.onModuleStart();
        }
    }
}

